/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dto;

import java.util.Date;
import java.util.Map;

import jp.mosp.payroll.bonus.BonusConst;
import jp.mosp.common.common.BaseDto;

public class BonusDetailDto extends BaseDto {

	private static final long serialVersionUID = 2613587750422757053L;
	
	// tB[h
	protected String kCode           = "";	// ЈR[h
	protected Date   calcDate            ;	// vZN
	protected Date   payday              ;	// ^x
	protected String calcStatus      = "";	// vZXe[^X
	protected String kName           = "";	// Ј
	protected String stationCode     = "";	// R[h
	protected String positionCode    = "";	// EʃR[h
	protected String employmentType  = "";	// ٗp敪
	protected Integer  bonusAllowance01	   ; // ܗ^x01
	protected Integer  bonusAllowance02	   ; // ܗ^x02
	protected Integer  bonusAllowance03	   ; // ܗ^x03
	protected Integer  bonusAllowance04	   ; // ܗ^x04
	protected Integer  bonusAllowance05	   ; // ܗ^x05
	protected Integer  bonusAllowance06	   ; // ܗ^x06
	protected Integer  bonusAllowance07	   ; // ܗ^x07
	protected Integer  bonusAllowance08	   ; // ܗ^x08
	protected Integer  bonusAllowance09	   ; // ܗ^x09
	protected Integer  bonusAllowance10	   ; // ܗ^x10
	protected Integer  bonusAllowance11	   ; // ܗ^x11
	protected Integer  bonusAllowance12	   ; // ܗ^x12
	protected Integer  bonusAllowance13	   ; // ܗ^x13
	protected Integer  bonusAllowance14	   ; // ܗ^x14
	protected Integer  bonusAllowance15	   ; // ܗ^x15
	protected Integer  bonusAllowance16	   ; // ܗ^x16
	protected Integer  bonusAllowance17	   ; // ܗ^x17
	protected Integer  bonusAllowance18	   ; // ܗ^x18
	protected Integer  bonusAllowance19	   ; // ܗ^x19
	protected Integer  bonusAllowance20	   ; // ܗ^x20
	protected Integer  healthInsurance    ;	// Nی
	protected Integer  pensionInsurance   ;	// Nی
	protected Integer  employeeInsurance  ;	// ٗpی
	protected Integer  incomeTax          ;	// 
	protected Integer  nursingInsurance   ;	// ی
	protected Integer  bonusDeduction06   ;	// ܗ^T06
	protected Integer  bonusDeduction07   ;	// ܗ^T07
	protected Integer  bonusDeduction08	   ; // ܗ^T08
	protected Integer  bonusDeduction09	   ; // ܗ^T09
	protected Integer  bonusDeduction10	   ; // ܗ^T10
	protected Integer  bonusDeduction11	   ; // ܗ^T11
	protected Integer  bonusDeduction12	   ; // ܗ^T12
	protected Integer  bonusDeduction13	   ; // ܗ^T13
	protected Integer  bonusDeduction14	   ; // ܗ^T14
	protected Integer  bonusDeduction15	   ; // ܗ^T15
	protected Integer  bonusDeduction16	   ; // ܗ^T16
	protected Integer  bonusDeduction17	   ; // ܗ^T17
	protected Integer  bonusDeduction18	   ; // ܗ^T18
	protected Integer  bonusDeduction19	   ; // ܗ^T19
	protected Integer  bonusDeduction20	   ; // ܗ^T20
	protected Integer  allowanceTotal      ;	// xz
	protected Integer  deductionTotal      ;	// Tz
	protected Integer  paymentTotal        ;	// xz
	protected Integer  bank1PayAmount      ;	// s1Uz
	protected Integer  bank2PayAmount      ;	// s2Uz
	protected Integer  cashPayAmount       ;	// xz
	protected Integer  dependentCount     ;	// }{̐
	protected Integer  lastMonthTaxation  ;	// O^̉ېőΏۊz
	protected Integer  totalYearBonus     ;	// Nx݌vܗ^z

	protected String belongCode         ;	// cƏR[h
	
	protected String  titleAllowance_01 ;	// x01^Cg
	protected String  titleAllowance_02 ;	// x02^Cg
	protected String  titleAllowance_03 ;	// x03^Cg
	protected String  titleAllowance_04 ;	// x04^Cg
	protected String  titleAllowance_05 ;	// x05^Cg
	protected String  titleAllowance_06 ;	// x06^Cg
	protected String  titleAllowance_07 ;	// x07^Cg
	protected String  titleAllowance_08 ;	// x08^Cg
	protected String  titleAllowance_09 ;	// x09^Cg
	protected String  titleAllowance_10 ;	// x10^Cg
	protected String  titleAllowance_11 ;	// x11^Cg
	protected String  titleAllowance_12 ;	// x12^Cg
	protected String  titleAllowance_13 ;	// x13^Cg
	protected String  titleAllowance_14 ;	// x14^Cg
	protected String  titleAllowance_15 ;	// x15^Cg
	protected String  titleAllowance_16 ;	// x16^Cg
	protected String  titleAllowance_17 ;	// x17^Cg
	protected String  titleAllowance_18 ;	// x18^Cg
	protected String  titleAllowance_19 ;	// x19^Cg
	protected String  titleAllowance_20 ;	// x20^Cg
	protected String  titleDeduction_01 ;	// T01^Cg
	protected String  titleDeduction_02 ;	// T02^Cg
	protected String  titleDeduction_03 ;	// T03^Cg
	protected String  titleDeduction_04 ;	// T04^Cg
	protected String  titleDeduction_05 ;	// T05^Cg
	protected String  titleDeduction_06 ;	// T06^Cg
	protected String  titleDeduction_07 ;	// T07^Cg
	protected String  titleDeduction_08 ;	// T08^Cg
	protected String  titleDeduction_09 ;	// T09^Cg
	protected String  titleDeduction_10 ;	// T10^Cg
	protected String  titleDeduction_11 ;	// T11^Cg
	protected String  titleDeduction_12 ;	// T12^Cg
	protected String  titleDeduction_13 ;	// T13^Cg
	protected String  titleDeduction_14 ;	// T14^Cg
	protected String  titleDeduction_15 ;	// T15^Cg
	protected String  titleDeduction_16 ;	// T16^Cg
	protected String  titleDeduction_17 ;	// T17^Cg
	protected String  titleDeduction_18 ;	// T18^Cg
	protected String  titleDeduction_19 ;	// T19^Cg
	protected String  titleDeduction_20 ;	// T20^Cg
	
	protected String  year;
	protected String  month;
	
	/**
	 * RXgN^
	 */
	public BonusDetailDto(PdBonusDto dto, Map<String, PsDetailDto> mapDetail){
		super();
		// ^f[^Ƃɒlݒ
		kCode              = dto.getKCode             ();
		calcDate           = dto.getCalcDate          ();
		payday             = dto.getPayday            ();
		calcStatus         = dto.getCalcStatus        ();
		kName              = dto.getKName             ();
		stationCode        = dto.getStationCode       ();
		positionCode       = dto.getPositionCode      ();
		employmentType     = dto.getEmploymentType    ();
		
		allowanceTotal     = new Integer(dto.getAllowanceTotal    ());
		deductionTotal     = new Integer(dto.getDeductionTotal    ());
		paymentTotal       = new Integer(dto.getPaymentTotal      ());
		bank1PayAmount     = new Integer(dto.getBank1PayAmount    ());
		bank2PayAmount     = new Integer(dto.getBank2PayAmount    ());
		cashPayAmount      = new Integer(dto.getCashPayAmount     ());
		dependentCount     = new Integer(dto.getDependentCount    ());
		lastMonthTaxation  = new Integer(dto.getLastMonthTaxation ());
		totalYearBonus     = new Integer(dto.getTotalYearBonus    ());
		
		// אݒƂɒlݒ
		
		
		bonusAllowance01   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_01 ), dto.getBonusAllowance01 ());
		bonusAllowance02   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_02 ), dto.getBonusAllowance02 ());
		bonusAllowance03   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_03 ), dto.getBonusAllowance03 ());
		bonusAllowance04   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_04 ), dto.getBonusAllowance04 ());
		bonusAllowance05   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_05 ), dto.getBonusAllowance05 ());
		bonusAllowance06   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_06 ), dto.getBonusAllowance06 ());
		bonusAllowance07   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_07 ), dto.getBonusAllowance07 ());
		bonusAllowance08   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_08 ), dto.getBonusAllowance08 ());
		bonusAllowance09   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_09 ), dto.getBonusAllowance09 ());
		bonusAllowance10   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_10 ), dto.getBonusAllowance10 ());
		bonusAllowance11   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_11 ), dto.getBonusAllowance11 ());
		bonusAllowance12   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_12 ), dto.getBonusAllowance12 ());
		bonusAllowance13   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_13 ), dto.getBonusAllowance13 ());
		bonusAllowance14   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_14 ), dto.getBonusAllowance14 ());
		bonusAllowance15   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_15 ), dto.getBonusAllowance15 ());
		bonusAllowance16   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_16 ), dto.getBonusAllowance16 ());
		bonusAllowance17   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_17 ), dto.getBonusAllowance17 ());
		bonusAllowance18   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_18 ), dto.getBonusAllowance18 ());
		bonusAllowance19   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_19 ), dto.getBonusAllowance19 ());
		bonusAllowance20   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_20 ), dto.getBonusAllowance20 ());
		healthInsurance    = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_01 ), dto.getHealthInsurance  ());
		pensionInsurance   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_02 ), dto.getPensionInsurance ());
		employeeInsurance  = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_03 ), dto.getEmployeeInsurance());
		incomeTax          = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_04 ), dto.getIncomeTax        ());
		nursingInsurance   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_05 ), dto.getNursingInsurance ());
		bonusDeduction06   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_06 ), dto.getBonusDeduction06 ());
		bonusDeduction06   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_07 ), dto.getBonusDeduction07 ());
		bonusDeduction08   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_08 ), dto.getBonusDeduction08 ());
		bonusDeduction09   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_09 ), dto.getBonusDeduction09 ());
		bonusDeduction10   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_10 ), dto.getBonusDeduction10 ());
		bonusDeduction11   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_11 ), dto.getBonusDeduction11 ());
		bonusDeduction12   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_12 ), dto.getBonusDeduction12 ());
		bonusDeduction13   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_13 ), dto.getBonusDeduction13 ());
		bonusDeduction14   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_14 ), dto.getBonusDeduction14 ());
		bonusDeduction15   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_15 ), dto.getBonusDeduction15 ());
		bonusDeduction16   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_16 ), dto.getBonusDeduction16 ());
		bonusDeduction17   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_17 ), dto.getBonusDeduction17 ());
		bonusDeduction18   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_18 ), dto.getBonusDeduction18 ());
		bonusDeduction19   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_19 ), dto.getBonusDeduction19 ());
		bonusDeduction20   = getDetailValue(getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_20 ), dto.getBonusDeduction20 ());
		
		titleAllowance_01  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_01), bonusAllowance01 );
		titleAllowance_02  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_02), bonusAllowance02 );
		titleAllowance_03  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_03), bonusAllowance03 );
		titleAllowance_04  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_04), bonusAllowance04 );
		titleAllowance_05  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_05), bonusAllowance05 );
		titleAllowance_06  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_06), bonusAllowance06 );
		titleAllowance_07  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_07), bonusAllowance07 );
		titleAllowance_08  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_08), bonusAllowance08 );
		titleAllowance_09  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_09), bonusAllowance09 );
		titleAllowance_10  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_10), bonusAllowance10 );
		titleAllowance_11  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_11), bonusAllowance11 );
		titleAllowance_12  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_12), bonusAllowance12 ); 
		titleAllowance_13  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_13), bonusAllowance13 ); 
		titleAllowance_14  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_14), bonusAllowance14 );
		titleAllowance_15  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_15), bonusAllowance15 );
		titleAllowance_16  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_16), bonusAllowance16 );
		titleAllowance_17  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_17), bonusAllowance17 );
		titleAllowance_18  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_18), bonusAllowance18 );
		titleAllowance_19  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_19), bonusAllowance19 );
		titleAllowance_20  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_ALLOWANCE_20), bonusAllowance20 );
		titleDeduction_01  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_01), healthInsurance  );
		titleDeduction_02  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_02), pensionInsurance );
		titleDeduction_03  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_03), employeeInsurance);
		titleDeduction_04  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_04), incomeTax        );
		titleDeduction_05  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_05), nursingInsurance );
		titleDeduction_06  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_06), bonusDeduction06 );
		titleDeduction_07  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_07), bonusDeduction07 );
		titleDeduction_08  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_08), bonusDeduction08 );
		titleDeduction_09  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_09), bonusDeduction09 );
		titleDeduction_10  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_10), bonusDeduction10 );
		titleDeduction_11  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_11), bonusDeduction11 );
		titleDeduction_12  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_12), bonusDeduction12 );
		titleDeduction_13  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_13), bonusDeduction13 );
		titleDeduction_14  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_14), bonusDeduction14 );
		titleDeduction_15  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_15), bonusDeduction15 );
		titleDeduction_16  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_16), bonusDeduction16 );
		titleDeduction_17  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_17), bonusDeduction17 );
		titleDeduction_18  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_18), bonusDeduction18 );
		titleDeduction_19  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_19), bonusDeduction19 );
		titleDeduction_20  = getDetailName (getDetail(mapDetail, BonusConst.UP_BONUS_DEDUCTION_20), bonusDeduction20 );

		
	}
	
	/**
	 * אݒ擾B<br>
	 * @param mapDetail  אݒ
	 * @param detailCode אݒR[h
	 * @return
	 */
	private PsDetailDto getDetail(
			Map<String, PsDetailDto> mapDetail, String detailCode
	) {
		if (mapDetail == null) {
			return null;
		}
		return mapDetail.get(detailCode);
	}
	
	/**
	 * ז̂擾B<br>
	 * @param detail אݒ
	 * @param value  גl
	 * @return ז
	 */
	private String getDetailName(PsDetailDto detail, Integer value) {
		// אݒ肪ꍇ
		if (detail == null) {
			return "";
		}
		// 0~\ł0~̏ꍇ
		if ((value == null || value.intValue() == 0) &&
				BonusConst.DISPLAY_NOT_ZERO.equals(detail.getDetailDisplay())) {
			return "";
		}
		// ȊȌꍇ
		return detail.getDetailName();
	}
	
	/**
	 * גl擾B<br>
	 * @param detail אݒ
	 * @param value  גl
	 * @return גl
	 */
	private Integer getDetailValue(PsDetailDto detail, int value) {
		// אݒ肪0~̏ꍇ
		if (detail == null && value == 0) {
			return null;
		}
		// אݒ肪0~\ł0~̏ꍇ
		if (detail != null && value == 0 &&
				BonusConst.DISPLAY_NOT_ZERO.equals(detail.getDetailDisplay())) {
			return null;
		}
		// ȊȌꍇ
		return new Integer(value);
	}
	
	// ANZT\bh
	public String getKCode         () { return kCode                 ; }	// ЈR[h
	public Date   getCalcDate      () { return getDateField(calcDate); }	// vZN
	public Date   getPayday        () { return getDateField(payday  ); }	// ^x
	public String getCalcStatus    () { return calcStatus            ; }	// vZXe[^X
	public String getKName         () { return kName                 ; }	// Ј
	public String getStationCode   () { return stationCode           ; }	// R[h
	public String getPositionCode  () { return positionCode          ; }	// EʃR[h
	public String getEmploymentType() { return employmentType        ; }	// ٗp敪
	public Integer  getBonusAllowance01 () { return bonusAllowance01 ; }	// ܗ^x01
	public Integer  getBonusAllowance02 () { return bonusAllowance02 ; }	// ܗ^x02
	public Integer  getBonusAllowance03 () { return bonusAllowance03 ; }	// ܗ^x03
	public Integer  getBonusAllowance04 () { return bonusAllowance04 ; }	// ܗ^x04
	public Integer  getBonusAllowance05 () { return bonusAllowance05 ; }	// ܗ^x05
	public Integer  getBonusAllowance06 () { return bonusAllowance06 ; }	// ܗ^x06
	public Integer  getBonusAllowance07 () { return bonusAllowance07 ; }	// ܗ^x07
	public Integer  getBonusAllowance08 () { return bonusAllowance08 ; }	// ܗ^x08
	public Integer  getBonusAllowance09 () { return bonusAllowance09 ; }	// ܗ^x09
	public Integer  getBonusAllowance10 () { return bonusAllowance10 ; }	// ܗ^x10
	public Integer  getBonusAllowance11 () { return bonusAllowance11 ; }	// ܗ^x11
	public Integer  getBonusAllowance12 () { return bonusAllowance12 ; }	// ܗ^x12
	public Integer  getBonusAllowance13 () { return bonusAllowance13 ; }	// ܗ^x13
	public Integer  getBonusAllowance14 () { return bonusAllowance14 ; }	// ܗ^x14
	public Integer  getBonusAllowance15 () { return bonusAllowance15 ; }	// ܗ^x15
	public Integer  getBonusAllowance16 () { return bonusAllowance16 ; }	// ܗ^x16
	public Integer  getBonusAllowance17 () { return bonusAllowance17 ; }	// ܗ^x17
	public Integer  getBonusAllowance18 () { return bonusAllowance18 ; }	// ܗ^x18
	public Integer  getBonusAllowance19 () { return bonusAllowance19 ; }	// ܗ^x19
	public Integer  getBonusAllowance20 () { return bonusAllowance20 ; }	// ܗ^x20
	public Integer  getHealthInsurance  () { return healthInsurance  ; }	// Nی
	public Integer  getPensionInsurance () { return pensionInsurance ; }	// Nی
	public Integer  getEmployeeInsurance() { return employeeInsurance; }	// ٗpی
	public Integer  getIncomeTax        () { return incomeTax        ; }	// 
	public Integer  getNursingInsurance () { return nursingInsurance ; }	// ی
	public Integer  getBonusDeduction06 () { return bonusDeduction06 ; }	// ܗ^T06
	public Integer  getBonusDeduction07 () { return bonusDeduction07 ; }	// ܗ^T07
	public Integer  getBonusDeduction08 () { return bonusDeduction08 ; }	// ܗ^T08
	public Integer  getBonusDeduction09 () { return bonusDeduction09 ; }	// ܗ^T09
	public Integer  getBonusDeduction10 () { return bonusDeduction10 ; }	// ܗ^T10
	public Integer  getBonusDeduction11 () { return bonusDeduction11 ; }	// ܗ^T11
	public Integer  getBonusDeduction12 () { return bonusDeduction12 ; }	// ܗ^T12
	public Integer  getBonusDeduction13 () { return bonusDeduction13 ; }	// ܗ^T13
	public Integer  getBonusDeduction14 () { return bonusDeduction14 ; }	// ܗ^T14
	public Integer  getBonusDeduction15 () { return bonusDeduction15 ; }	// ܗ^T15
	public Integer  getBonusDeduction16 () { return bonusDeduction16 ; }	// ܗ^T16
	public Integer  getBonusDeduction17 () { return bonusDeduction17 ; }	// ܗ^T17
	public Integer  getBonusDeduction18 () { return bonusDeduction18 ; }	// ܗ^T18
	public Integer  getBonusDeduction19 () { return bonusDeduction19 ; }	// ܗ^T19
	public Integer  getBonusDeduction20 () { return bonusDeduction20 ; }	// ܗ^T20
	public Integer  getAllowanceTotal   () { return allowanceTotal   ; }	// xz
	public Integer  getDeductionTotal   () { return deductionTotal   ; }	// Tz
	public Integer  getPaymentTotal     () { return paymentTotal     ; }	// xz
	public Integer  getBank1PayAmount   () { return bank1PayAmount   ; }	// s1Uz
	public Integer  getBank2PayAmount   () { return bank2PayAmount   ; }	// s2Uz
	public Integer  getCashPayAmount    () { return cashPayAmount    ; }	// xz
	public Integer  getDependentCount   () { return dependentCount   ; }	// }{̐
	public Integer  getLastMonthTaxation() { return lastMonthTaxation; }	// O^̉ېőΏۊz
	public Integer  getTotalYearBonus   () { return totalYearBonus   ; }	// Nx݌vܗ^z
	public String  getBelongCode        () { return belongCode            ; }	// cƏR[h

	
	public String  getTitleAllowance_01 () { return titleAllowance_01     ; }	// x01^Cg
	public String  getTitleAllowance_02 () { return titleAllowance_02     ; }	// x02^Cg
	public String  getTitleAllowance_03 () { return titleAllowance_03     ; }	// x03^Cg
	public String  getTitleAllowance_04 () { return titleAllowance_04     ; }	// x04^Cg
	public String  getTitleAllowance_05 () { return titleAllowance_05     ; }	// x05^Cg
	public String  getTitleAllowance_06 () { return titleAllowance_06     ; }	// x06^Cg
	public String  getTitleAllowance_07 () { return titleAllowance_07     ; }	// x07^Cg
	public String  getTitleAllowance_08 () { return titleAllowance_08     ; }	// x08^Cg
	public String  getTitleAllowance_09 () { return titleAllowance_09     ; }	// x09^Cg
	public String  getTitleAllowance_10 () { return titleAllowance_10     ; }	// x10^Cg
	public String  getTitleAllowance_11 () { return titleAllowance_11     ; }	// x11^Cg
	public String  getTitleAllowance_12 () { return titleAllowance_12     ; }	// x12^Cg
	public String  getTitleAllowance_13 () { return titleAllowance_13     ; }	// x13^Cg
	public String  getTitleAllowance_14 () { return titleAllowance_14     ; }	// x14^Cg
	public String  getTitleAllowance_15 () { return titleAllowance_15     ; }	// x15^Cg
	public String  getTitleAllowance_16 () { return titleAllowance_16     ; }	// x16^Cg
	public String  getTitleAllowance_17 () { return titleAllowance_17     ; }	// x17^Cg
	public String  getTitleAllowance_18 () { return titleAllowance_18     ; }	// x18^Cg
	public String  getTitleAllowance_19 () { return titleAllowance_19     ; }	// x19^Cg
	public String  getTitleAllowance_20 () { return titleAllowance_20     ; }	// x20^Cg
	public String  getTitleDeduction_01 () { return titleDeduction_01     ; }	// T01^Cg
	public String  getTitleDeduction_02 () { return titleDeduction_02     ; }	// T02^Cg
	public String  getTitleDeduction_03 () { return titleDeduction_03     ; }	// T03^Cg
	public String  getTitleDeduction_04 () { return titleDeduction_04     ; }	// T04^Cg
	public String  getTitleDeduction_05 () { return titleDeduction_05     ; }	// T05^Cg
	public String  getTitleDeduction_06 () { return titleDeduction_06     ; }	// T06^Cg
	public String  getTitleDeduction_07 () { return titleDeduction_07     ; }	// T07^Cg
	public String  getTitleDeduction_08 () { return titleDeduction_08     ; }	// T08^Cg
	public String  getTitleDeduction_09 () { return titleDeduction_09     ; }	// T09^Cg
	public String  getTitleDeduction_10 () { return titleDeduction_10     ; }	// T10^Cg
	public String  getTitleDeduction_11 () { return titleDeduction_11     ; }	// T11^Cg
	public String  getTitleDeduction_12 () { return titleDeduction_12     ; }	// T12^Cg
	public String  getTitleDeduction_13 () { return titleDeduction_13     ; }	// T13^Cg
	public String  getTitleDeduction_14 () { return titleDeduction_14     ; }	// T14^Cg
	public String  getTitleDeduction_15 () { return titleDeduction_15     ; }	// T15^Cg
	public String  getTitleDeduction_16 () { return titleDeduction_16     ; }	// T16^Cg
	public String  getTitleDeduction_17 () { return titleDeduction_17     ; }	// T17^Cg
	public String  getTitleDeduction_18 () { return titleDeduction_18     ; }	// T18^Cg
	public String  getTitleDeduction_19 () { return titleDeduction_19     ; }	// T19^Cg
	public String  getTitleDeduction_20 () { return titleDeduction_20     ; }	// T20^Cg
	
	public String  getYear              () { return year                  ; }
	public String  getMonth             () { return month                 ; }
	
	public void setKCode             (String kCode             ) { this.kCode              = kCode            ; }	// ЈR[h
	public void setCalcDate          (Date   calcDate          ) { this.calcDate           = getDateField(calcDate); }	// vZN
	public void setPayday            (Date   payday            ) { this.payday             = getDateField(payday)  ; }	// ^x
	public void setCalcStatus        (String calcStatus        ) { this.calcStatus         = calcStatus            ; }	// vZXe[^X
	public void setKName             (String kName             ) { this.kName              = kName                 ; }	// Ј
	public void setStationCode       (String stationCode       ) { this.stationCode        = stationCode           ; }	// R[h
	public void setPositionCode      (String positionCode      ) { this.positionCode       = positionCode          ; }	// EʃR[h
	public void setEmploymentType    (String employmentType    ) { this.employmentType     = employmentType        ; }	// ٗp敪
	public void setBonusAllowance01 (Integer  bonusAllowance01 ) { this.bonusAllowance01  = bonusAllowance01 ; }	// ܗ^x01
	public void setBonusAllowance02 (Integer  bonusAllowance02 ) { this.bonusAllowance02  = bonusAllowance02 ; }	// ܗ^x02
	public void setBonusAllowance03 (Integer  bonusAllowance03 ) { this.bonusAllowance03  = bonusAllowance03 ; }	// ܗ^x03
	public void setBonusAllowance04 (Integer  bonusAllowance04 ) { this.bonusAllowance04  = bonusAllowance04 ; }	// ܗ^x04
	public void setBonusAllowance05 (Integer  bonusAllowance05 ) { this.bonusAllowance05  = bonusAllowance05 ; }	// ܗ^x05
	public void setBonusAllowance06 (Integer  bonusAllowance06 ) { this.bonusAllowance06  = bonusAllowance06 ; }	// ܗ^x06
	public void setBonusAllowance07 (Integer  bonusAllowance07 ) { this.bonusAllowance07  = bonusAllowance07 ; }	// ܗ^x07
	public void setBonusAllowance08 (Integer  bonusAllowance08 ) { this.bonusAllowance08  = bonusAllowance08 ; }	// ܗ^x08
	public void setBonusAllowance09 (Integer  bonusAllowance09 ) { this.bonusAllowance09  = bonusAllowance09 ; }	// ܗ^x09
	public void setBonusAllowance10 (Integer  bonusAllowance10 ) { this.bonusAllowance10  = bonusAllowance10 ; }	// ܗ^x10
	public void setBonusAllowance11 (Integer  bonusAllowance11 ) { this.bonusAllowance11  = bonusAllowance11 ; }	// ܗ^x11
	public void setBonusAllowance12 (Integer  bonusAllowance12 ) { this.bonusAllowance12  = bonusAllowance12 ; }	// ܗ^x12
	public void setBonusAllowance13 (Integer  bonusAllowance13 ) { this.bonusAllowance13  = bonusAllowance13 ; }	// ܗ^x13
	public void setBonusAllowance14 (Integer  bonusAllowance14 ) { this.bonusAllowance14  = bonusAllowance14 ; }	// ܗ^x14
	public void setBonusAllowance15 (Integer  bonusAllowance15 ) { this.bonusAllowance15  = bonusAllowance15 ; }	// ܗ^x15
	public void setBonusAllowance16 (Integer  bonusAllowance16 ) { this.bonusAllowance16  = bonusAllowance16 ; }	// ܗ^x16
	public void setBonusAllowance17 (Integer  bonusAllowance17 ) { this.bonusAllowance17  = bonusAllowance17 ; }	// ܗ^x17
	public void setBonusAllowance18 (Integer  bonusAllowance18 ) { this.bonusAllowance18  = bonusAllowance18 ; }	// ܗ^x18
	public void setBonusAllowance19 (Integer  bonusAllowance19 ) { this.bonusAllowance19  = bonusAllowance19 ; }	// ܗ^x19
	public void setBonusAllowance20 (Integer  bonusAllowance20 ) { this.bonusAllowance20  = bonusAllowance20 ; }	// ܗ^x20
	public void setHealthInsurance  (Integer  healthInsurance  ) { this.healthInsurance   = healthInsurance  ; }	// Nی
	public void setPensionInsurance (Integer  pensionInsurance ) { this.pensionInsurance  = pensionInsurance ; }	// Nی
	public void setEmployeeInsurance(Integer  employeeInsurance) { this.employeeInsurance = employeeInsurance; }	// ٗpی
	public void setIncomeTax        (Integer  incomeTax        ) { this.incomeTax         = incomeTax        ; }	// 
	public void setNursingInsurance (Integer  nursingInsurance ) { this.nursingInsurance  = nursingInsurance ; }	// ی
	public void setBonusDeduction06 (Integer  bonusDeduction06 ) { this.bonusDeduction06  = bonusDeduction06 ; }	// ܗ^T06
	public void setBonusDeduction07 (Integer  bonusDeduction07 ) { this.bonusDeduction07  = bonusDeduction07 ; }	// ܗ^T07
	public void setBonusDeduction08 (Integer  bonusDeduction08 ) { this.bonusDeduction08  = bonusDeduction08 ; }	// ܗ^T08
	public void setBonusDeduction09 (Integer  bonusDeduction09 ) { this.bonusDeduction09  = bonusDeduction09 ; }	// ܗ^T09
	public void setBonusDeduction10 (Integer  bonusDeduction10 ) { this.bonusDeduction10  = bonusDeduction10 ; }	// ܗ^T10
	public void setBonusDeduction11 (Integer  bonusDeduction11 ) { this.bonusDeduction11  = bonusDeduction11 ; }	// ܗ^T11
	public void setBonusDeduction12 (Integer  bonusDeduction12 ) { this.bonusDeduction12  = bonusDeduction12 ; }	// ܗ^T12
	public void setBonusDeduction13 (Integer  bonusDeduction13 ) { this.bonusDeduction13  = bonusDeduction13 ; }	// ܗ^T13
	public void setBonusDeduction14 (Integer  bonusDeduction14 ) { this.bonusDeduction14  = bonusDeduction14 ; }	// ܗ^T14
	public void setBonusDeduction15 (Integer  bonusDeduction15 ) { this.bonusDeduction15  = bonusDeduction15 ; }	// ܗ^T15
	public void setBonusDeduction16 (Integer  bonusDeduction16 ) { this.bonusDeduction16  = bonusDeduction16 ; }	// ܗ^T16
	public void setBonusDeduction17 (Integer  bonusDeduction17 ) { this.bonusDeduction17  = bonusDeduction17 ; }	// ܗ^T17
	public void setBonusDeduction18 (Integer  bonusDeduction18 ) { this.bonusDeduction18  = bonusDeduction18 ; }	// ܗ^T18
	public void setBonusDeduction19 (Integer  bonusDeduction19 ) { this.bonusDeduction19  = bonusDeduction19 ; }	// ܗ^T19
	public void setBonusDeduction20 (Integer  bonusDeduction20 ) { this.bonusDeduction20  = bonusDeduction20 ; }	// ܗ^T20
	public void setAllowanceTotal   (Integer  allowanceTotal   ) { this.allowanceTotal    = allowanceTotal   ; }	// xz
	public void setDeductionTotal   (Integer  deductionTotal   ) { this.deductionTotal    = deductionTotal   ; }	// Tz
	public void setPaymentTotal     (Integer  paymentTotal     ) { this.paymentTotal      = paymentTotal     ; }	// xz
	public void setBank1PayAmount   (Integer  bank1PayAmount   ) { this.bank1PayAmount    = bank1PayAmount   ; }	// s1Uz
	public void setBank2PayAmount   (Integer  bank2PayAmount   ) { this.bank2PayAmount    = bank2PayAmount   ; }	// s2Uz
	public void setCashPayAmount    (Integer  cashPayAmount    ) { this.cashPayAmount     = cashPayAmount    ; }	// xz
	public void setDependentCount   (Integer  dependentCount   ) { this.dependentCount    = dependentCount   ; }	// }{̐
	public void setLastMonthTaxation(Integer  lastMonthTaxation) { this.lastMonthTaxation = lastMonthTaxation; }	// }{̐
	public void setTotalYearBonus   (Integer  totalYearBonus   ) { this.totalYearBonus    = totalYearBonus   ; }	// }{̐
	public void setBelongCode        (String  belongCode       ) { this.belongCode        = belongCode              ; }	// R[h

	
	public void setTitleAllowance_01 (String  titleAllowance_01 ) { this.titleAllowance_01  = titleAllowance_01     ; }	// x01^Cg
	public void setTitleAllowance_02 (String  titleAllowance_02 ) { this.titleAllowance_02  = titleAllowance_02     ; }	// x02^Cg
	public void setTitleAllowance_03 (String  titleAllowance_03 ) { this.titleAllowance_03  = titleAllowance_03     ; }	// x03^Cg
	public void setTitleAllowance_04 (String  titleAllowance_04 ) { this.titleAllowance_04  = titleAllowance_04     ; }	// x04^Cg
	public void setTitleAllowance_05 (String  titleAllowance_05 ) { this.titleAllowance_05  = titleAllowance_05     ; }	// x05^Cg
	public void setTitleAllowance_06 (String  titleAllowance_06 ) { this.titleAllowance_06  = titleAllowance_06     ; }	// x06^Cg
	public void setTitleAllowance_07 (String  titleAllowance_07 ) { this.titleAllowance_07  = titleAllowance_07     ; }	// x07^Cg
	public void setTitleAllowance_08 (String  titleAllowance_08 ) { this.titleAllowance_08  = titleAllowance_08     ; }	// x08^Cg
	public void setTitleAllowance_09 (String  titleAllowance_09 ) { this.titleAllowance_09  = titleAllowance_09     ; }	// x09^Cg
	public void setTitleAllowance_10 (String  titleAllowance_10 ) { this.titleAllowance_10  = titleAllowance_10     ; }	// x10^Cg
	public void setTitleAllowance_11 (String  titleAllowance_11 ) { this.titleAllowance_11  = titleAllowance_11     ; }	// x11^Cg
	public void setTitleAllowance_12 (String  titleAllowance_12 ) { this.titleAllowance_12  = titleAllowance_12     ; }	// x12^Cg
	public void setTitleAllowance_13 (String  titleAllowance_13 ) { this.titleAllowance_13  = titleAllowance_13     ; }	// x13^Cg
	public void setTitleAllowance_14 (String  titleAllowance_14 ) { this.titleAllowance_14  = titleAllowance_14     ; }	// x14^Cg
	public void setTitleAllowance_15 (String  titleAllowance_15 ) { this.titleAllowance_15  = titleAllowance_15     ; }	// x15^Cg
	public void setTitleAllowance_16 (String  titleAllowance_16 ) { this.titleAllowance_16  = titleAllowance_16     ; }	// x16^Cg
	public void setTitleAllowance_17 (String  titleAllowance_17 ) { this.titleAllowance_17  = titleAllowance_17     ; }	// x17^Cg
	public void setTitleAllowance_18 (String  titleAllowance_18 ) { this.titleAllowance_18  = titleAllowance_18     ; }	// x18^Cg
	public void setTitleAllowance_19 (String  titleAllowance_19 ) { this.titleAllowance_19  = titleAllowance_19     ; }	// x19^Cg
	public void setTitleAllowance_20 (String  titleAllowance_20 ) { this.titleAllowance_20  = titleAllowance_20     ; }	// x20^Cg
	public void setTitleDeduction_01 (String  titleDeduction_01 ) { this.titleDeduction_01  = titleDeduction_01     ; }	// T01^Cg
	public void setTitleDeduction_02 (String  titleDeduction_02 ) { this.titleDeduction_02  = titleDeduction_02     ; }	// T02^Cg
	public void setTitleDeduction_03 (String  titleDeduction_03 ) { this.titleDeduction_03  = titleDeduction_03     ; }	// T03^Cg
	public void setTitleDeduction_04 (String  titleDeduction_04 ) { this.titleDeduction_04  = titleDeduction_04     ; }	// T04^Cg
	public void setTitleDeduction_05 (String  titleDeduction_05 ) { this.titleDeduction_05  = titleDeduction_05     ; }	// T05^Cg
	public void setTitleDeduction_06 (String  titleDeduction_06 ) { this.titleDeduction_06  = titleDeduction_06     ; }	// T06^Cg
	public void setTitleDeduction_07 (String  titleDeduction_07 ) { this.titleDeduction_07  = titleDeduction_07     ; }	// T07^Cg
	public void setTitleDeduction_08 (String  titleDeduction_08 ) { this.titleDeduction_08  = titleDeduction_08     ; }	// T08^Cg
	public void setTitleDeduction_09 (String  titleDeduction_09 ) { this.titleDeduction_09  = titleDeduction_09     ; }	// T09^Cg
	public void setTitleDeduction_10 (String  titleDeduction_10 ) { this.titleDeduction_10  = titleDeduction_10     ; }	// T10^Cg
	public void setTitleDeduction_11 (String  titleDeduction_11 ) { this.titleDeduction_11  = titleDeduction_11     ; }	// T11^Cg
	public void setTitleDeduction_12 (String  titleDeduction_12 ) { this.titleDeduction_12  = titleDeduction_12     ; }	// T12^Cg
	public void setTitleDeduction_13 (String  titleDeduction_13 ) { this.titleDeduction_13  = titleDeduction_13     ; }	// T13^Cg
	public void setTitleDeduction_14 (String  titleDeduction_14 ) { this.titleDeduction_14  = titleDeduction_14     ; }	// T14^Cg
	public void setTitleDeduction_15 (String  titleDeduction_15 ) { this.titleDeduction_15  = titleDeduction_15     ; }	// T15^Cg
	public void setTitleDeduction_16 (String  titleDeduction_16 ) { this.titleDeduction_16  = titleDeduction_16     ; }	// T16^Cg
	public void setTitleDeduction_17 (String  titleDeduction_17 ) { this.titleDeduction_17  = titleDeduction_17     ; }	// T17^Cg
	public void setTitleDeduction_18 (String  titleDeduction_18 ) { this.titleDeduction_18  = titleDeduction_18     ; }	// T18^Cg
	public void setTitleDeduction_19 (String  titleDeduction_19 ) { this.titleDeduction_19  = titleDeduction_19     ; }	// T19^Cg
	public void setTitleDeduction_20 (String  titleDeduction_20 ) { this.titleDeduction_20  = titleDeduction_20     ; }	// T20^Cg
	
	public void setYear              (String  year              ) { this.year               = year                  ; }
	public void setMonth             (String  month             ) { this.month              = month                 ; }
	
}
